$.extend({
	SELECTED_ICON: 'http://maps.google.com/mapfiles/ms/icons/blue.png',
	DESELECTED_ICON: 'http://maps.google.com/mapfiles/ms/icons/red.png',
	lightmap: {
		markers: {},
		map: null,
		shiftPressed: false,
		mouseIsDown: false,
		mouseStartPos: null,
		bounds: null,
		boundingBox: null,
		
		showMap: function(container, opts, callback) {
			var self = this, _ = google.maps, key, key2, val, val2, i, marker,
				options = opts || {},
				mapOptions = {
					center: new _.LatLng(options.lat || 53.801279,
										 options.lng || -1.548567),
					zoom: options.zoom || 5,
					mapTypeId: options.type || _.MapTypeId.ROADMAP
				},
				infowindow = new _.InfoWindow(),
				red = $.DESELECTED_ICON,
				blue = $.SELECTED_ICON;

			delete options.lat;
			delete options.lng;
			$.extend(mapOptions, options);
			self.map = new _.Map(container[0], mapOptions);
			for (key in self.markers) {
				val = self.markers[key];
				marker = null;
				
				for (i = 0; i < Object.keys(self.markers).length; i++) {
					key2 = Object.keys(self.markers)[i];
					if (key2 === key) continue;
					val2 = self.markers[key2];
					if (val.id < val2.id) continue;
					if (val.longitude !== val2.longitude
						|| val.latitude !== val2.latitude) continue;
					marker = new _.Marker({
						position: val.pos,
						map: self.map,
						title: key,
						icon: red
					});
					val.marker = marker;
				}
				
				if (!marker) continue;
				
				_.event.addListener(marker, 'click', (function(marker, title) {
					return function () {
						var txt = '<div style="line-height:1.35">' + title
								+ ' <a class="btn btn-default btn-sm" href="'
								+ '/edit?ids[]=' + self.markers[title].id
								+ '&all=true">Edit Schedule</a>'
								+ '</div>',
							k, v;

						for (k in self.markers) {
							v = self.markers[k];
							if (!v.marker) continue;
							
							if (v.marker.getIcon() !== red) {
								v.marker.setIcon(red);
							}
						}
						
						if (infowindow.getContent() === txt) {
							infowindow.setContent('');
							infowindow.close();
						} else {
							if (marker.getIcon() !== blue) {
								marker.setIcon(blue);
							}
							infowindow.setContent(txt);
							infowindow.open(self.map, marker);
						}
					};
				})(marker, key));
				
				_.event.addListener(marker, 'icon_changed', (function(m) {
					return function() {
						updateSearchResultsWithLatLng(m.position,
													  m.getIcon() === blue);
					};
				})(marker));
			}

			$(window).keydown(function(eventObject) {
				if (eventObject.which === 16) self.shiftPressed = true;
			}).keyup(function(eventObject) {
				if (eventObject.which === 16) self.shiftPressed = false;
			});

			_.event.addListener(self.map, 'mousemove', function(e) {
				var sw = {}, ne = {};
				
				if (self.mouseIsDown && self.shiftPressed) {
					if (!self.boundingBox) {
						self.boundingBox = new _.Rectangle({
							map: self.map,
							bounds: new _.LatLngBounds(),
							fillOpacity: 0.15,
							strokeWeight: 0.9,
							clickable: false
						});
					}
					
					sw.lat = Math.min(self.mouseStartPos.lat(), e.latLng.lat());
					ne.lat = Math.max(self.mouseStartPos.lat(), e.latLng.lat());
					sw.lng = Math.min(self.mouseStartPos.lng(), e.latLng.lng());
					ne.lng = Math.max(self.mouseStartPos.lng(), e.latLng.lng());
					self.boundingBox.setBounds(new _.LatLngBounds(sw, ne));
				}
			});

			_.event.addListener(self.map, 'mousedown', function(e) {
				if (self.shiftPressed) {
					self.mouseIsDown = true;
					self.mouseStartPos = e.latLng;
					self.map.setOptions({ draggable: false });
				}
			});

			_.event.addListener(self.map, 'mouseup', function(e) {
				var boundsSelectionArea;

				if (self.mouseIsDown && self.shiftPressed) {
					self.mouseIsDown = false;
					if (self.boundingBox) {
						boundsSelectionArea = new _.LatLngBounds(
								self.boundingBox.getBounds().getSouthWest(),
								self.boundingBox.getBounds().getNorthEast());

						for (key in self.markers) {
							val = self.markers[key];
							if (!val.marker) continue;
							
							if (self.boundingBox.getBounds()
									.contains(val.marker.getPosition())) {
								if (val.marker.getIcon() !== blue) {
									val.marker.setIcon(blue);
								}
							} else {
								if (val.marker.getIcon() !== red) {
									val.marker.setIcon(red);
								}
							}
						}

						self.boundingBox.setMap(null);
					}
					self.boundingBox = null;
				}

				self.map.setOptions({ draggable: true });
			});
			callback();
		}
	}
});
